﻿using System;
using System.Collections.Generic;
using System.ServiceModel.DomainServices.Client;
using System.Windows;
using System.Windows.Controls;
using AlbumsCatalog.Web;

namespace AlbumsCatalog
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();
            Loaded += new RoutedEventHandler(MainPage_Loaded);
        }

        // Abschluss des Ladevorgangs dieser Ansicht...
        void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
            // Erzeuge Kontext
            AlbumsDomainContext ctx = new AlbumsDomainContext();
            // Lade Query   
            var loadoperation = ctx.Load<Artist>(ctx.GetArtistsQuery());
            // Registriere Completed-Ereignis
            loadoperation.Completed += new EventHandler(loadoperation_Completed);
        }

        void loadoperation_Completed(object sender, EventArgs e)
        {
            // Ermittle geladene Entitäten
            var entities = (sender as LoadOperation<Artist>).Entities as ICollection<Artist>;
            // Gebe das Ergebnis aus
            MessageBox.Show(entities.Count +" Künstler geladen.");
        }

        private void artistDomainDataSource_LoadedData(object sender, System.Windows.Controls.LoadedDataEventArgs e)
        {

            if (e.HasError)
            {
                System.Windows.MessageBox.Show(e.Error.ToString(), "Load Error", System.Windows.MessageBoxButton.OK);
                e.MarkErrorAsHandled();
            }
        }
    }
}
